/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs;

import com.ibm.hwmca.base.settings.network.NetworkInterfaceInformation;
import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.fcs.FcsEvent;
import com.ibm.hwmca.fw.fcs.FcsEventListener;
import com.ibm.hwmca.fw.fcs.FcsException;
import com.ibm.hwmca.fw.fcs.FcsService;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.fcs.impl.FcsConfigManager;
import com.ibm.hwmca.fw.fcs.impl.FcsConnectionManager;
import com.ibm.hwmca.fw.fcs.impl.FcsErrorIds;
import com.ibm.hwmca.fw.fcs.impl.FcsInternalConstants;
import com.ibm.hwmca.fw.fcs.impl.MachineDataInfo;
import com.ibm.hwmca.fw.fcs.impl.disc.DiscoveryCenter;
import com.ibm.hwmca.fw.fcs.impl.disc.bcast.DatagramPortOwner;
import com.ibm.hwmca.fw.fcs.impl.stream.StreamConstants;
import com.ibm.hwmca.fw.fcs.impl.udp.FcsDatagram;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.settings.network.NetworkSettingsChangedEvent;
import com.ibm.hwmca.fw.settings.network.NetworkSettingsChangedEventListener;
import com.ibm.hwmca.fw.util.Trace;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FcsServer
implements FcsInternalConstants,
StreamConstants,
NetworkSettingsChangedEventListener {
    private static final String TRACE_MASKD = "XFCSSVRD";
    private static final String TRACE_MASKF = "XFCSSVRF";
    private static final String TRACE_MASKT = "XFCSSVRT";
    private static FcsServer _singleton;
    private static MachineId localMachine;
    private static boolean stopped;
    private Date bootTime;
    private static Set blackListedMachines;
    private Map localServices;
    private Map otherMachineServices;
    private Object localServicesLock;
    private Object otherServicesLock;
    private Object fcsEventListenersLock;
    private static Object fcsLock;
    FcsConnectionManager fcsConnectionManager;
    private List fcsEventListeners;
    private FcsConfigManager configManager;
    public static final int FCS_FILTER_LT = 1;
    public static final int FCS_FILTER_LTE = 2;
    public static final int FCS_FILTER_EQ = 3;
    public static final int FCS_FILTER_GTE = 4;
    public static final int FCS_FILTER_GT = 5;
    public static final int FCS_FILTER_NEQ = 6;
    public static final int FCS_FILTER_ALL = 7;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$fcs$chatlet$ChatletService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FcsServer() throws FcsException {
        Trace.trace(TRACE_MASKT, "-> FcsServer()");
        localMachine = this.getMachineIdentification();
        this.bootTime = new Date();
        this.localServicesLock = new Object();
        this.otherServicesLock = new Object();
        this.fcsEventListenersLock = new Object();
        this.otherMachineServices = new HashMap();
        this.localServices = new HashMap();
        this.fcsEventListeners = new ArrayList();
        Object object = this.localServicesLock;
        synchronized (object) {
            this.localServices.put(new FcsServiceId("com.ibm.hwmca.fw.fcs.impl.stream.StreamToken", 1.0), "com.ibm.hwmca.fw.fcs.impl.stream.StreamReceiver");
            this.localServices.put(new FcsServiceId("com.ibm.hwmca.fw.fcs.impl.stream.FcsControlServiceToken", 1.0), "com.ibm.hwmca.fw.fcs.impl.stream.FcsControlService");
            this.localServices.put(new FcsServiceId("FcsChatletService", 1.0), (class$com$ibm$hwmca$fw$fcs$chatlet$ChatletService == null ? (class$com$ibm$hwmca$fw$fcs$chatlet$ChatletService = FcsServer.class$("com.ibm.hwmca.fw.fcs.chatlet.ChatletService")) : class$com$ibm$hwmca$fw$fcs$chatlet$ChatletService).getName());
        }
        this.configure();
        Trace.trace(TRACE_MASKT, "<- FcsServer()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure() {
        String configFileName;
        try {
            configFileName = BaseFileControl.getFilePath("FcsConfig.xml") + "FcsConfig.xml";
        }
        catch (HException he) {
            Trace.trace(TRACE_MASKF, "Error in getting file path");
            configFileName = "FcsConfig.xml";
        }
        this.configManager = new FcsConfigManager(configFileName);
        this.configManager.readConfig();
        FcsConnectionManager.setMachineListPingTime(this.configManager.getMachineListPingTime());
        Set whiteList = this.configManager.getAddedMachines();
        Iterator iterator = whiteList.iterator();
        while (iterator.hasNext()) {
            String addy = (String)iterator.next();
            try {
                InetAddress iaddr = InetAddress.getByName(addy);
                Trace.trace(TRACE_MASKF, "adding whitelist entry:" + addy);
                FcsConnectionManager.addWhiteListedMachine(iaddr);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Exception with whitelist entry: " + addy);
            }
        }
        Set blackList = this.configManager.getBlockedMachines();
        Iterator iterator2 = blackList.iterator();
        while (iterator2.hasNext()) {
            String addy = (String)iterator2.next();
            try {
                InetAddress iaddr = InetAddress.getByName(addy);
                Trace.trace(TRACE_MASKF, "adding blacklist entry:" + addy);
                FcsServer.addBlackListedMachine(iaddr);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Exception with blacklist entry: " + addy);
            }
        }
        Object object = this.localServicesLock;
        synchronized (object) {
            Iterator iterator3 = this.configManager.getInitialServices().keySet().iterator();
            while (iterator3.hasNext()) {
                FcsServiceId tmpId = (FcsServiceId)iterator3.next();
                Object tmpSvc = this.configManager.getInitialServices().get(tmpId);
                Trace.trace(TRACE_MASKF, "adding initial service: " + tmpId);
                this.localServices.put(tmpId, tmpSvc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized FcsServer getFcsServer() {
        block6: {
            if (_singleton != null) break block6;
            try {
                Object object = fcsLock;
                synchronized (object) {
                    if (!stopped) {
                        _singleton = new FcsServer();
                        DiscoveryCenter.getDiscoveryCenter();
                        FcsServer._singleton.fcsConnectionManager = new FcsConnectionManager();
                        FcsServer._singleton.fcsConnectionManager.start();
                    }
                }
            }
            catch (FcsException fcse) {
                fcse.printStackTrace();
            }
        }
        return _singleton;
    }

    public MachineId getLocalMachineId() {
        return localMachine;
    }

    public Date getLocalBootTime() {
        return this.bootTime;
    }

    public FcsConfigManager getConfigManager() {
        return this.configManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MachineId getMachineId(InetAddress iaddr) {
        if (iaddr != null) {
            Object object = this.otherServicesLock;
            synchronized (object) {
                Iterator i = this.otherMachineServices.keySet().iterator();
                while (i.hasNext()) {
                    MachineId tmp = (MachineId)i.next();
                    int j = 0;
                    while (j < tmp.getNicAddresses().length) {
                        if (tmp.getNicAddresses()[j] != null && tmp.getNicAddresses()[j].getHostAddress().equals(iaddr.getHostAddress())) {
                            return tmp;
                        }
                        ++j;
                    }
                }
            }
        }
        return null;
    }

    public Date getBootTime(MachineId machineId) throws IllegalArgumentException {
        if (machineId == null) {
            throw new IllegalArgumentException("machineId passed to getBootTime() can not be null");
        }
        Object o = this.otherMachineServices.get(machineId);
        if (o == null) {
            return null;
        }
        return ((MachineDataInfo)o).getBootTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalService(FcsServiceId newService, String fullyQualifiedClassName) throws IllegalArgumentException {
        if (newService == null) {
            throw new IllegalArgumentException("FcsServiceId passed in to FcsServer.addService() may not be null");
        }
        if (fullyQualifiedClassName == null) {
            throw new IllegalArgumentException("Class name passed in to FcsServer.addService() may not be null");
        }
        try {
            Class<?> cl = Class.forName(fullyQualifiedClassName);
            FcsService service = (FcsService)cl.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("Invalid class name passed in to FcsService.addService(): " + fullyQualifiedClassName);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Invalid class name passed in to FcsService.addService(): " + fullyQualifiedClassName);
        }
        catch (InstantiationException ie) {
            throw new IllegalArgumentException("Invalid class name passed in to FcsService.addService(): " + fullyQualifiedClassName);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Invalid class name passed in to FcsService.addService(): " + fullyQualifiedClassName);
        }
        Trace.trace(TRACE_MASKT, "-> addLocalService(" + newService + ")");
        Object object = this.localServicesLock;
        synchronized (object) {
            this.localServices.put(newService, fullyQualifiedClassName);
            this.addRemoteServiceList(this.getLocalMachineId(), this.getLocalServices(), this.bootTime);
        }
        this.notifyKnownMachines();
        HashSet<FcsServiceId> s = new HashSet<FcsServiceId>();
        s.add(newService);
        final FcsEvent event = new FcsEvent(2, 100, this.getLocalMachineId(), s);
        Thread t = new Thread("FCS Server - addLocalService event thread"){

            public void run() {
                Trace.trace(FcsServer.TRACE_MASKF, "Firing FCS Server addLocalService event");
                FcsServer.getFcsServer().fireFcsEvent(event);
            }
        };
        t.start();
        Trace.trace(TRACE_MASKT, "<- addLocalService(FcsServiceId, String)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalService(FcsServiceId newService, FcsService service) throws IllegalArgumentException {
        if (newService == null) {
            throw new IllegalArgumentException("FcsServiceId passed in to FcsServer.addService() may not be null");
        }
        if (service == null) {
            throw new IllegalArgumentException("FcsService passed in to FcsServer.addService() may not be null");
        }
        Trace.trace(TRACE_MASKT, "-> addLocalService(" + newService + ")");
        Object object = this.localServicesLock;
        synchronized (object) {
            this.localServices.put(newService, service);
            this.addRemoteServiceList(this.getLocalMachineId(), this.getLocalServices(), this.bootTime);
        }
        if (!newService.isTemporaryServiceId()) {
            this.notifyKnownMachines();
        }
        HashSet<FcsServiceId> s = new HashSet<FcsServiceId>();
        s.add(newService);
        final FcsEvent event = new FcsEvent(2, 100, this.getLocalMachineId(), s);
        Thread t = new Thread("FCS Server - addLocalService event thread"){

            public void run() {
                Trace.trace(FcsServer.TRACE_MASKF, "Firing FCS Server addLocalService event");
                FcsServer.getFcsServer().fireFcsEvent(event);
            }
        };
        t.start();
        Trace.trace(TRACE_MASKT, "<- addLocalService(FcsServiceId, FcsService)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalService(FcsServiceId service) {
        if (service == null) {
            throw new IllegalArgumentException("FcsServiceId passed in to FcsServer.removeService() may not be null");
        }
        FcsServiceId temp = null;
        Object object = this.localServicesLock;
        synchronized (object) {
            this.localServices.remove(service);
            this.addRemoteServiceList(this.getLocalMachineId(), this.getLocalServices(), this.bootTime);
        }
        if (temp != null && !temp.isTemporaryServiceId()) {
            this.notifyKnownMachines();
            HashSet<FcsServiceId> s = new HashSet<FcsServiceId>();
            s.add(service);
            final FcsEvent event = new FcsEvent(2, 101, this.getLocalMachineId(), s);
            Thread t = new Thread("FCS Server - removeLocalService event thread"){

                public void run() {
                    Trace.trace(FcsServer.TRACE_MASKF, "Firing FCS Server removeLocalService event");
                    FcsServer.getFcsServer().fireFcsEvent(event);
                }
            };
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getLocalServices() {
        HashSet set = new HashSet();
        Object object = this.localServicesLock;
        synchronized (object) {
            Iterator i = this.localServices.keySet().iterator();
            while (i.hasNext()) {
                set.add(i.next());
            }
        }
        return set;
    }

    public Set getSupportingMachines(FcsServiceId service) {
        return this.getSupportingMachines(service, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getSupportingMachines(FcsServiceId service, int compareType) {
        Map otherMachines;
        HashSet<MachineId> set = new HashSet<MachineId>();
        Object object = this.otherServicesLock;
        synchronized (object) {
            otherMachines = (Map)((HashMap)this.otherMachineServices).clone();
        }
        Iterator i = otherMachines.keySet().iterator();
        while (i.hasNext()) {
            MachineId machineId = (MachineId)i.next();
            Set serviceList = ((MachineDataInfo)otherMachines.get(machineId)).getServices();
            Iterator j = serviceList.iterator();
            while (j.hasNext()) {
                FcsServiceId serviceId = (FcsServiceId)j.next();
                if (!serviceId.getServiceName().equals(service.getServiceName())) continue;
                if (compareType == 1 && serviceId.getVersion() < service.getVersion()) {
                    set.add(machineId);
                    continue;
                }
                if (compareType == 2 && serviceId.getVersion() <= service.getVersion()) {
                    set.add(machineId);
                    continue;
                }
                if (compareType == 3 && serviceId.getVersion() == service.getVersion()) {
                    set.add(machineId);
                    continue;
                }
                if (compareType == 4 && serviceId.getVersion() >= service.getVersion()) {
                    set.add(machineId);
                    continue;
                }
                if (compareType == 5 && serviceId.getVersion() > service.getVersion()) {
                    set.add(machineId);
                    continue;
                }
                if (compareType == 6 && serviceId.getVersion() != service.getVersion()) {
                    set.add(machineId);
                    continue;
                }
                if (compareType != 7) continue;
                set.add(machineId);
            }
        }
        otherMachines = null;
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FcsServiceId getServiceId(MachineId machineId, String serviceName) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "<> getServiceId()");
        if (machineId == null) {
            throw new IllegalArgumentException("MachineId passed to getServiceVersion() can not be null");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Service name passed to getServiceVersion() can not be null");
        }
        Object object = this.otherServicesLock;
        synchronized (object) {
            MachineDataInfo mdi = (MachineDataInfo)this.otherMachineServices.get(machineId);
            if (mdi != null) {
                Set services = mdi.getServices();
                Iterator iterator = mdi.getServices().iterator();
                while (iterator.hasNext()) {
                    FcsServiceId id = (FcsServiceId)iterator.next();
                    if (!id.getServiceName().equals(serviceName)) continue;
                    return new FcsServiceId(id.getServiceName(), id.getVersion());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFcsEventListener(FcsEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("FcsEventListener may not be null");
        }
        Object object = this.fcsEventListenersLock;
        synchronized (object) {
            this.fcsEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFcsEventListener(FcsEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("FcsEventListener may not be null");
        }
        Object object = this.fcsEventListenersLock;
        synchronized (object) {
            this.fcsEventListeners.remove(listener);
        }
    }

    public static void addBlackListedMachine(InetAddress iaddr) {
        blackListedMachines.add(iaddr);
    }

    public static void removeBlackListedMachine(InetAddress iaddr) {
        blackListedMachines.remove(iaddr);
    }

    public static Set getBlackListedMachines() {
        return (Set)((HashSet)blackListedMachines).clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getMachineList() {
        HashSet<MachineId> set = new HashSet<MachineId>();
        Object object = this.otherServicesLock;
        synchronized (object) {
            Iterator i = this.otherMachineServices.keySet().iterator();
            while (i.hasNext()) {
                MachineId machineId = (MachineId)i.next();
                set.add(machineId);
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteServiceList(MachineId machine, Set services, Date date) {
        Trace.trace(TRACE_MASKT, "-> addRemoteServiceList()");
        InetAddress[] tmpadds = machine.getNicAddresses();
        int i = 0;
        while (i < tmpadds.length) {
            if (tmpadds[i] == null) {
                Trace.trace(TRACE_MASKF, "null NIC for machineId: " + machine);
                Trace.trace(TRACE_MASKF, "not adding remote service list");
                return;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < machine.getNicAddresses().length) {
            if (machine.getNicAddresses()[i2].getHostAddress().equals("0.0.0.0")) {
                Trace.trace(TRACE_MASKF, "incoming machine had IP of 0.0.0.0 - not adding it");
                return;
            }
            if (machine.getNicAddresses()[i2].getHostAddress().equals("255.255.255.255")) {
                Trace.trace(TRACE_MASKF, "incoming machine had IP of 255.255.255.255 - not adding it");
                return;
            }
            ++i2;
        }
        ArrayList<FcsEvent> eventList = new ArrayList<FcsEvent>();
        Object object = this.otherServicesLock;
        synchronized (object) {
            MachineDataInfo oldDataInfo = (MachineDataInfo)this.otherMachineServices.get(machine);
            if (oldDataInfo != null) {
                if (!date.equals(oldDataInfo.getBootTime())) {
                    int i3 = 0;
                    while (i3 < machine.getNicAddresses().length) {
                        FcsConnectionManager.removeConnectionInformation(machine.getNicAddresses()[i3]);
                        ++i3;
                    }
                    Set oldServices = oldDataInfo.getServices();
                    oldDataInfo.setBootTime(date);
                    oldDataInfo.setServices(services);
                    FcsEvent event = new FcsEvent(1, 53, machine, oldServices);
                    eventList.add(event);
                } else {
                    FcsEvent event;
                    Set oldServices = oldDataInfo.getServices();
                    oldDataInfo.setServices(services);
                    HashSet<FcsServiceId> addedDeltaServices = new HashSet<FcsServiceId>();
                    HashSet<FcsServiceId> subtractedDeltaServices = new HashSet<FcsServiceId>();
                    Iterator iterator = oldServices.iterator();
                    while (iterator.hasNext()) {
                        FcsServiceId tmp = (FcsServiceId)iterator.next();
                        if (services.contains(tmp)) continue;
                        subtractedDeltaServices.add(tmp);
                    }
                    Iterator iterator2 = services.iterator();
                    while (iterator2.hasNext()) {
                        FcsServiceId tmp = (FcsServiceId)iterator2.next();
                        if (oldServices.contains(tmp)) continue;
                        addedDeltaServices.add(tmp);
                    }
                    if (addedDeltaServices.size() > 0) {
                        event = new FcsEvent(2, 100, machine, addedDeltaServices);
                        eventList.add(event);
                    }
                    if (subtractedDeltaServices.size() > 0) {
                        event = new FcsEvent(2, 101, machine, subtractedDeltaServices);
                        eventList.add(event);
                    }
                }
                this.otherMachineServices.put(machine, oldDataInfo);
            } else {
                MachineDataInfo dataInfo = new MachineDataInfo();
                dataInfo.setBootTime(date);
                dataInfo.setServices(services);
                this.otherMachineServices.put(machine, dataInfo);
                FcsEvent event = new FcsEvent(1, 51, machine, services);
                eventList.add(event);
            }
        }
        if (eventList.size() > 0) {
            final ArrayList<FcsEvent> fEventList = eventList;
            Thread t = new Thread("FCS Server - addRemoteService event thread"){

                public void run() {
                    Trace.trace(FcsServer.TRACE_MASKF, "Firing FCS Server addRemoteService event");
                    Iterator iterator = fEventList.iterator();
                    while (iterator.hasNext()) {
                        FcsServer.getFcsServer().fireFcsEvent((FcsEvent)iterator.next());
                    }
                }
            };
            t.start();
        }
        Trace.trace(TRACE_MASKT, "<- addRemoteServiceList()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FcsService getService(FcsServiceId serviceId) {
        Trace.trace(TRACE_MASKT, "<> getService(): " + serviceId);
        Object o = null;
        Object object = this.localServicesLock;
        synchronized (object) {
            Iterator i = this.localServices.keySet().iterator();
            while (i.hasNext()) {
                FcsServiceId service = (FcsServiceId)i.next();
                if (!service.getServiceName().equals(serviceId.getServiceName()) || !(service.getVersion() >= serviceId.getVersion())) continue;
                o = this.localServices.get(service);
            }
        }
        if (o != null) {
            if (o instanceof FcsService) {
                return o;
            }
            try {
                o = Class.forName(o).newInstance();
                return o;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Error instantiating: " + (String)o);
            }
        }
        Trace.trace(TRACE_MASKF, "getService() " + serviceId + " is returning null");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteServiceList(MachineId machine) {
        if (machine != null) {
            MachineDataInfo mdi = null;
            Object object = this.otherServicesLock;
            synchronized (object) {
                mdi = (MachineDataInfo)this.otherMachineServices.remove(machine);
            }
            int i = 0;
            while (i < machine.getNicAddresses().length) {
                if (machine.getNicAddresses()[i] != null) {
                    FcsConnectionManager.removeConnectionInformation(machine.getNicAddresses()[i]);
                }
                ++i;
            }
            if (mdi != null) {
                final FcsEvent event = new FcsEvent(1, 52, machine, mdi.getServices());
                Thread t = new Thread("FCS Server - removeRemoteService event thread"){

                    public void run() {
                        Trace.trace(FcsServer.TRACE_MASKF, "Firing FCS Server removeRemoteService event");
                        FcsServer.getFcsServer().fireFcsEvent(event);
                    }
                };
                t.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyKnownMachines() {
        Map otherMachines;
        Object object = this.otherServicesLock;
        synchronized (object) {
            otherMachines = (Map)((HashMap)this.otherMachineServices).clone();
        }
        Iterator i = otherMachines.keySet().iterator();
        while (i.hasNext()) {
            MachineId machineId = (MachineId)i.next();
            FcsDatagram datagram = new FcsDatagram(localMachine, 3);
            DatagramPacket packet = datagram.asPacket();
            packet.setAddress(machineId.getNicAddresses()[0]);
            packet.setPort(9900);
            DatagramPortOwner.getDatagramPortOwner().send(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFcsEvent(FcsEvent event) {
        List listenersList;
        Object object = this.fcsEventListenersLock;
        synchronized (object) {
            listenersList = (List)((ArrayList)this.fcsEventListeners).clone();
        }
        Iterator iterator = listenersList.iterator();
        while (iterator.hasNext()) {
            FcsEventListener listener = (FcsEventListener)iterator.next();
            listener.fcsStateChanged(event);
        }
    }

    /*
     * Unable to fully structure code
     */
    private MachineId getMachineIdentification() throws FcsException {
        ns = NetworkSettings.getNetworkSettings();
        if (ns == null) {
            e = new FcsException("Base Tower not initialized!");
            new FrameworkLog(FcsErrorIds._logInfo, 2144, e).log(FrameworkLogAttributes.INFO_LOG);
            throw e;
        }
        try {
            bGroup = SimServer.getSimServer().readSim(18);
            i = 0;
            while (i < bGroup.length) {
                if (bGroup[i] == 0) break;
                ++i;
            }
            group = new String(bGroup, 0, i);
            Trace.trace("XFCSSVRF", "domain name: [" + group + "]");
        }
        catch (Exception e) {
            group = "group";
        }
        try {
            Trace.trace("XFCSSVRF", "getting computer name");
            machineName = ns.getNetworkInfo().getComputerName();
            if (machineName == null || machineName.trim().equals("")) {
                Trace.trace("XFCSSVRF", "error getting computer name from base tower");
                machineName = InetAddress.getLocalHost().getHostName();
            }
            Trace.trace("XFCSSVRF", "computer name: " + machineName);
        }
        catch (Exception e) {
            machineName = "Machine";
        }
        Trace.trace("XFCSSVRF", "getting nic info");
        iaddrs = null;
        networkInterfaceInformation = ns.getNetworkInterfaceInfo();
        if (networkInterfaceInformation != null && networkInterfaceInformation.size() > 0) {
            iaddrs = new InetAddress[networkInterfaceInformation.size()];
            i = 0;
            while (i < iaddrs.length) {
                if (networkInterfaceInformation.get(i) == null || ((NetworkInterfaceInformation)networkInterfaceInformation.get(i)).getIpAddress() == null) {
                    try {
                        iaddrs[i] = InetAddress.getByName("127.0.0.1");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    iaddrs[i] = ((NetworkInterfaceInformation)networkInterfaceInformation.get(i)).getIpAddress();
                }
                Trace.trace("XFCSSVRF", "nic[" + i + "]:" + iaddrs[i]);
                ++i;
            }
        } else {
            Trace.trace("XFCSSVRF", "error getting nic info from base tower");
            try {
                iaddrs = new InetAddress[]{InetAddress.getLocalHost()};
                if (!iaddrs[0].getHostAddress().equals("0.0.0.0")) ** GOTO lbl67
                Trace.trace("XFCSSVRF", "Local address was 0.0.0.0, attempt to convert to 127.0.0.1");
                localIaddrs = InetAddress.getAllByName("127.0.0.1");
                if (localIaddrs == null) ** GOTO lbl67
                i = 0;
                while (i < localIaddrs.length) {
                    if (!localIaddrs[i].getHostAddress().equals("0.0.0.0")) {
                        iaddrs[0] = localIaddrs[i];
                        i = localIaddrs.length;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                new FrameworkLog(FcsErrorIds._logInfo, 2145, e).log(FrameworkLogAttributes.INFO_LOG);
                throw new FcsException(e);
            }
        }
lbl67:
        // 4 sources

        publicNetworkIndicators = new boolean[iaddrs.length];
        i = 0;
        while (i < publicNetworkIndicators.length) {
            try {
                publicNetworkIndicators[i] = ((NetworkInterfaceInformation)networkInterfaceInformation.get(i)).isPrivateIf() == false;
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        machineType = null;
        machineModel = null;
        machineSerial = null;
        machineType = HMC.getHMC().getMachineType();
        machineModel = HMC.getHMC().getMachineModel();
        machineSerial = HMC.getHMC().getMachineSerial();
        mid = new MachineId(machineName, group, 1.0, 1, 1, iaddrs, publicNetworkIndicators, machineType, machineModel, machineSerial);
        addrs = mid.getNicAddresses();
        ok = false;
        if (addrs != null) {
            i = 0;
            while (i < addrs.length) {
                if (addrs[i] != null && !addrs[i].getHostAddress().startsWith("127.")) {
                    Trace.trace("XFCSSVRF", "OK address: " + addrs[i].getHostAddress());
                    ok = true;
                    i = addrs.length;
                }
                ++i;
            }
        }
        if (!ok) {
            Trace.trace("XFCSSVRF", "The local machine only had the loopback address for IPs.  Check your network settings & hosts file");
            e = new Exception("The local machine only had the loopback address for IPs.  Check your network settings & hosts file");
            new FrameworkLog(FcsErrorIds._logInfo, 2145, e).log(FrameworkLogAttributes.INFO_LOG);
        }
        return mid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void domainNameChanged(String newName) {
        Trace.trace(TRACE_MASKT, "-> domainNameChanged (from \"" + localMachine.getGroup() + "\" to \"" + newName + "\")");
        MachineId oldMachineId = new MachineId(localMachine.getName(), localMachine.getGroup(), localMachine.getVersion(), localMachine.getType(), localMachine.getFcsVersion(), localMachine.getNicAddresses(), localMachine.getPublicNetworkIndicators());
        localMachine = new MachineId(localMachine.getName(), newName, localMachine.getVersion(), localMachine.getType(), localMachine.getFcsVersion(), localMachine.getNicAddresses(), localMachine.getPublicNetworkIndicators(), localMachine.getMachineType(), localMachine.getMachineModel(), localMachine.getMachineSerial());
        Object object = this.otherServicesLock;
        synchronized (object) {
            MachineDataInfo mdi = (MachineDataInfo)this.otherMachineServices.remove(oldMachineId);
            this.otherMachineServices.put(localMachine, mdi);
        }
        this.fcsConnectionManager.domainNameChanged();
        final FcsEvent fcsEvent = new FcsEvent(1, 54, localMachine, oldMachineId, this.getLocalServices());
        Thread t = new Thread("FCS Server - domain name changed event thread"){

            public void run() {
                Trace.trace(FcsServer.TRACE_MASKF, "Firing domain name changed fcs event");
                Set machines = FcsServer.getFcsServer().getMachineList();
                FcsServer.getFcsServer().fireFcsEvent(fcsEvent);
                Iterator iterator = machines.iterator();
                while (iterator.hasNext()) {
                    MachineId tmp = (MachineId)iterator.next();
                    if (tmp.equals(FcsServer.getFcsServer().getLocalMachineId())) continue;
                    Trace.trace(FcsServer.TRACE_MASKF, "Firing machine removed fcs event (due to domain name change)");
                    FcsServer.getFcsServer().removeRemoteServiceList(tmp);
                }
            }
        };
        t.start();
        Trace.trace(TRACE_MASKT, "<- domainNameChanged()");
    }

    public void networkSettingsChanged(NetworkSettingsChangedEvent event) {
        Trace.trace(TRACE_MASKT, "-> network settings changed");
        MachineId oldMachineId = new MachineId(localMachine.getName(), localMachine.getGroup(), localMachine.getVersion(), localMachine.getType(), localMachine.getFcsVersion(), localMachine.getNicAddresses(), localMachine.getPublicNetworkIndicators(), localMachine.getMachineType(), localMachine.getMachineModel(), localMachine.getMachineSerial());
        String computerName = event.getNetworkInfo().getComputerName();
        if (computerName == null || computerName.trim().equals("")) {
            Trace.trace(TRACE_MASKF, "error with new network name, using old name");
            computerName = oldMachineId.getName();
        }
        InetAddress[] iaddrs = null;
        List networkInterfaceInformation = event.getNetworkInterfaceInformation();
        if (networkInterfaceInformation == null || networkInterfaceInformation.size() == 0) {
            Trace.trace(TRACE_MASKF, "error with new network IP info, using old IP info");
            iaddrs = oldMachineId.getNicAddresses();
        } else {
            iaddrs = new InetAddress[networkInterfaceInformation.size()];
            int i = 0;
            while (i < iaddrs.length) {
                iaddrs[i] = ((NetworkInterfaceInformation)networkInterfaceInformation.get(i)).getIpAddress();
                ++i;
            }
        }
        boolean[] publicNetworkIndicators = new boolean[iaddrs.length];
        int i = 0;
        while (i < publicNetworkIndicators.length) {
            try {
                publicNetworkIndicators[i] = !((NetworkInterfaceInformation)networkInterfaceInformation.get(i)).isPrivateIf();
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        localMachine = new MachineId(computerName, localMachine.getGroup(), localMachine.getVersion(), localMachine.getType(), localMachine.getFcsVersion(), iaddrs, publicNetworkIndicators, localMachine.getMachineType(), localMachine.getMachineModel(), localMachine.getMachineSerial());
        final FcsEvent fcsEvent = new FcsEvent(1, 54, localMachine, oldMachineId, this.getLocalServices());
        Thread t = new Thread("FCS Server - network settings changed event thread"){

            public void run() {
                Trace.trace(FcsServer.TRACE_MASKF, "Firing network settings changed fcs event");
                FcsServer.getFcsServer().fireFcsEvent(fcsEvent);
            }
        };
        t.start();
        Trace.trace(TRACE_MASKT, "<- Network Settings Changed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        Trace.trace(TRACE_MASKF, "-> FcsServer.dump()");
        Object object = this.localServicesLock;
        synchronized (object) {
            Trace.trace(TRACE_MASKF, "Local machine information: " + this.getLocalMachineId().toString());
            Trace.trace(TRACE_MASKF, "Local boot time: " + this.getLocalBootTime().toString());
            Trace.trace(TRACE_MASKF, "Local services: ");
            Set services = this.getLocalServices();
            Iterator iterator = services.iterator();
            while (iterator.hasNext()) {
                FcsServiceId id = (FcsServiceId)iterator.next();
                Trace.trace(TRACE_MASKF, id.toString());
            }
        }
        Object object2 = this.otherServicesLock;
        synchronized (object2) {
            Set machines = this.getMachineList();
            Iterator iterator = machines.iterator();
            while (iterator.hasNext()) {
                MachineId id = (MachineId)iterator.next();
                MachineDataInfo mdi = (MachineDataInfo)this.otherMachineServices.get(id);
                Trace.trace(TRACE_MASKF, "Remote machine information: " + id.toString());
                Trace.trace(TRACE_MASKF, "Boot time: " + mdi.getBootTime());
                Trace.trace(TRACE_MASKF, "Services: ");
                Set services = mdi.getServices();
                Iterator iteratorb = services.iterator();
                while (iteratorb.hasNext()) {
                    FcsServiceId serviceId = (FcsServiceId)iteratorb.next();
                    Trace.trace(TRACE_MASKF, serviceId.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        Object object = fcsLock;
        synchronized (object) {
            stopped = true;
            this.fcsConnectionManager.stopWork();
        }
        Thread t = new Thread("FCS Server - FCS Stopping event thread"){
            FcsEvent fcsEvent;
            {
                this.fcsEvent = new FcsEvent(3, 150, localMachine, FcsServer.this.getLocalServices());
            }

            public void run() {
                Trace.trace(FcsServer.TRACE_MASKF, "Firing FCS Server stopped event");
                FcsServer.getFcsServer().fireFcsEvent(this.fcsEvent);
            }
        };
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        Object object = fcsLock;
        synchronized (object) {
            stopped = false;
            this.fcsConnectionManager = new FcsConnectionManager();
            this.fcsConnectionManager.start();
        }
        Thread t = new Thread("FCS Server - FCS Restarting event thread"){
            FcsEvent fcsEvent;
            {
                this.fcsEvent = new FcsEvent(3, 151, localMachine, FcsServer.this.getLocalServices());
            }

            public void run() {
                Trace.trace(FcsServer.TRACE_MASKF, "Firing FCS Server restarted event");
                FcsServer.getFcsServer().fireFcsEvent(this.fcsEvent);
            }
        };
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopped() {
        Object object = fcsLock;
        synchronized (object) {
            return stopped;
        }
    }

    public boolean isBlackListed(MachineId tmp) {
        if (stopped) {
            return true;
        }
        InetAddress[] iaddrs = tmp.getNicAddresses();
        int i = 0;
        while (i < iaddrs.length) {
            if (iaddrs[i] != null && blackListedMachines.contains(iaddrs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        blackListedMachines = new HashSet();
        fcsLock = new Object();
    }
}

